using UnityEngine;
using System.Collections;

public enum goldState{FLOATING, TAKEN};

public class Gold : MonoBehaviour {
	
	public int value = 100;
	private int state = (int)goldState.FLOATING;
	public float coinDelay = 2.0f;
	private float resetTime = 0.0f;
	
	
	public Vector3 startPosition;
	
	// Use this for initialization
	void Start () {
		resetTime = Time.time - coinDelay;
		startPosition = gameObject.transform.position;
		//gameObject.transform.position += new Vector3( Random.Range(-1, 1) * 2.5f, 0, 0);
		//startTime = Time.time;
	}
	
	
	public void Reset() {
		resetTime = Time.time;
		gameObject.transform.position = new Vector3(startPosition.x, 20, startPosition.z);
		gameObject.transform.position += new Vector3( Random.Range(-1, 1), 0, 0);
	}
	
	// Update is called once per frame
	void Update () {
		if (Time.time > resetTime + coinDelay ){
			gameObject.transform.position -= new Vector3(0, 0.03f, 0);
		}
		if(gameObject.transform.position.y < -9.70f){
			gameObject.transform.position = new Vector3(gameObject.transform.position.x, 
			                                            20, gameObject.transform.position.z);
		}
	}
	
}
